CREATE OR REPLACE FUNCTION sp_DeleteTreeNode (VARCHAR)
RETURNS INTEGER AS $$
DECLARE
    pGuid ALIAS FOR $1;
    readyToMove INTEGER;
    foundNode INTEGER;
    affected_rows INTEGER DEFAULT 0;
    pACLid INTEGER DEFAULT 0;
BEGIN

DELETE
FROM tb_local_repo_device_binding
WHERE device_guid = pGuid
  OR local_repo_guid = pGuid;


DELETE
FROM tb_device_info
WHERE guid = pGuid
  AND pGuid IS NOT NULL
  AND pGuid NOT IN
    (SELECT tb_system_node.guid
     FROM tb_system_node);


DELETE
FROM "tb_tree_node"
WHERE guid = pGuid
  AND pGuid IS NOT NULL
  AND pGuid NOT IN
    (SELECT tb_system_node.guid
     FROM tb_system_node);

SELECT id INTO pACLid FROM tb_acl_object_identity WHERE object_id = pGuid;
DELETE FROM tb_acl_entry WHERE object_identity_id = pACLid;
DELETE FROM tb_acl_object_identity WHERE object_id = pGuid;

GET DIAGNOSTICS affected_rows = ROW_COUNT;

RETURN affected_rows;
END

$$ LANGUAGE plpgsql;
